<?php

class HmsController extends Controller
{

    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        if (!Csrf::isTokenValid()) {
          //redirect to forbidden and exit
          header('HTTP/1.0 403 Forbidden', true, 403);
          exit();
        }

        $this->user=Auth::isAuthenticated();
    }

    public function index()
    {

        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $this->View->render('hms/index', array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'classes' => HmsModel::getAllVehicleClasses()
        ));
    }

    public function ssi()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});;

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[Session::get('vehicleid')."_SSI_View"]["granted"])$files[]='hms/ssi';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'inspectionversion' => HmsModel::getLatestReleaseInspectionVersion($vehicleid)
        ),'header_view');
    }

    public function safety()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[Session::get('vehicleid')."_Safety_View"]["granted"])$files[]='hms/safety';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'inspectionversion' => HmsModel::getLatestReleaseInspectionVersion($vehicleid)
        ),'header_view');
    }

    public function repair()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Repair_View/Search"]["granted"])$files[]='hms/repair';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'generalrepairschemes' => HmsModel::getRepairSchemeList($vehicleid),
            'specificrepairschemes' => HmsModel::getSpecificRepairSchemeList($vehicleid),
            'inspectionversion' => HmsModel::getLatestReleaseInspectionVersion($vehicleid)
        ),'header_view');
    }

    public function inspection()
    {

        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index_fixed');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Inspection_View/Search"]["granted"]||$permissions[$vehicleid."_Condition_View/Search"]["granted"])$files[]='hms/inspection';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'versionmap' => array(2=>"Pre-release",3=>"Release"),
            'inspectionversions' => HmsModel::getInspectionVersions($vehicleid),
            'inspectionintervals' => HmsModel::getInspectionIntervals($vehicleid),
            'holdingunits' => HmsModel::getHoldingUnits($vehicleid),
            'vehiclestatuses' => HmsModel::getVehicleStatuses($vehicleid)
        ),'header_fixed');

    }

    public function reference()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});
        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index_fixed');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Reference_View/Search"]["granted"])$files[]='hms/reference';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'years' => array_reverse(UtilityModel::getDatesFromRange('1999-01-01'))
        ),'header_fixed');
    }

    public function statistics()
    {
        header('GET');
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index_fixed');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Statistics_View/Search"]["granted"])$files[]='hms/statistics';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'versionmap' => array(2=>"Pre-release",3=>"Release"),
            'inspectionversions' => HmsModel::getInspectionVersions($vehicleid),
            'inspectionintervals' => HmsModel::getInspectionIntervals($vehicleid),
            'holdingunits' => HmsModel::getHoldingUnits($vehicleid),
            'vehiclestatuses' => HmsModel::getVehicleStatuses($vehicleid)
        ),'header_fixed');


    }


    public function scheduler()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('hms/index_fixed');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Scheduler_View/Search"]["granted"])$files[]='hms/scheduler';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'holdingunits' => HmsModel::getHoldingUnits($vehicleid)
        ),'header_fixed');

    }


    public function selectVehicle($id)
    {
        Session::set('vehicleid',$id);
        $classes=HmsModel::getAllVehicleClasses();
        $url=$_SERVER['HTTP_REFERER'];
        header('Location: '.$url);
    }

    public function getViewByType()
    {
        $vehicleid=Session::get('vehicleid');
        $type=Validate::string(Request::post('type'));
        $view=Validate::string(Request::post('view'));
        $version=Validate::int(Request::post('version'));
        $results=HmsModel::getViewByType($vehicleid,$type,$view,$version);
        // output json results
        echo $results;
    }

    public function getSpecificRepairByVRN()
    {
        $vehicleid=Session::get('vehicleid');
        $vrn=Validate::string(Request::post('vrn'));
        $results=HmsModel::getSpecificRepairByVRN($vehicleid,$vrn);
        $this->View->renderJSON($results);

    }

    public function searchInspection()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('inspectionVersion'));
        $vrn=Validate::string(Request::post('vrn'));
        $date=Validate::date(Request::post('date'));
        $interval=Validate::int(Request::post('inspectionInterval'));
        $unit=Validate::string(Request::post('holdingUnit'));
        $status=Validate::int(Request::post('status'));
        $completed=Validate::int(Request::post('completed'));
        $statusmap=array("","Fully operational","Limited role","Non operational");
        // load views
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/inspectionresults', array(
            'results' => HmsModel::getInspectionResults($vehicleid,$version,$vrn,$date,$interval,$unit,$status,$completed),
            'intervalmap' => HmsModel::getInspectionIntervalsMap($vehicleid),
            'statusmap' => array("","Fully operational","Limited role","Non operational")
        ));
    }

    public function searchCondition()
    {
        $vehicleid=Session::get('vehicleid');
        $vrn=Validate::string(Request::post('vrn'));
        $unit=Validate::string(Request::post('holdingUnit'));
        $status=Validate::int(Request::post('status'));
        $score=Validate::int(Request::post('score'));
        $scoretype=Validate::string(Request::post('scoretype'));
        // load views
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/conditionresults', array(
            'results' => HmsModel::getConditionResults($vehicleid,$vrn,$unit,$status,$score,$scoretype),
            'statusmap' => array("","Fully operational","Limited role","Non operational"),
            'filter' => array("vrn" => $vrn, "unit" => $unit, "status" => $status, "score" => $score, "scoretype" => $scoretype)
        ));
    }

    public function getConditionReport()
    {
        $this->View->renderWithoutHeaderAndFooter('hms/pdf/condition');
    }

    public function searchReferenceMaterial()
    {
        $vrn=Validate::string(Request::post('vrn'));
        $vidno=Validate::string(Request::post('vidno'));
        $general=Validate::string(Request::post('general'));
        $year=Validate::string(Request::post('year'));
        // load views
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/referencematerialresults', array(
            'results' => HmsModel::getReferenceMaterialResults($vrn,$vidno,$general,$year),
            'statusmap' => array("","Fully operational","Limited role","Non operational")
        ));
    }

    public function getReferenceMaterialRecord()
    {
        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/referencematerialrecord', array(
            'results' => HmsModel::getReferenceMaterialRecord($id)
        ));
    }

    public function searchVehicleInfo()
    {
        $vrn=Validate::string(Request::post('vrn'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/vehicleinforesults', array(
            'results' => HmsModel::getVehicleInfoResults($vrn)
        ));
    }

    public function getVehicleInfoRecord()
    {
        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/vehicleinforecord', array(
            'results' => HmsModel::getVehicleInfoRecord($id)
        ));
    }

    public function searchMinutes()
    {
        $general=Validate::string(Request::post('general'));
        $year=Validate::string(Request::post('year'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/minutesresults', array(
            'results' => HmsModel::getMinutesResults($general,$year)
        ));
    }

    public function getMinutesRecord()
    {
        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/minutesrecord', array(
            'results' => HmsModel::getMinutesRecord($id)
        ));
    }

    public function searchStatistics(){

        $vehicleid=$_SESSION['vehicleid'];
        $version=Validate::int(Request::post('version'));
        $vrn=Validate::string(Request::post('vrn'));
        $date=Validate::string(Request::post('date'));
        $interval=Validate::int(Request::post('interval'));
        $unit=Validate::string(Request::post('unit'));
        $status=Validate::int(Request::post('status'));
        $completed=Validate::int(Request::post('completed'));
        $this->View->renderWithoutHeaderAndFooter('hms/ajax/statisticsresults', array(
            'results' => HmsModel::getStatisticsResults($vehicleid,$version,$vrn,$date,$interval,$unit,$status,$completed),
            'filters' => array(
                'vehicleid' => $vehicleid,
                'version' => $version,
                'vrn' => $vrn,
                'date' => $date,
                'interval' => $interval,
                'unit' => $unit,
                'status' => $status,
                'completed' => $completed
            )
        ));
    }

    public function getStatisticsReport()
    {

        $this->View->renderWithoutHeaderAndFooter('hms/pdf/statistics');
    }

    public function searchScheduler()
    {
        $vehicleid=$_SESSION['vehicleid'];
        $vrn=Validate::string(Request::post('vrn'));
        $unit=Validate::string(Request::post('holdingUnit'));
        $inspectionDue=Validate::string(Request::post('inspectionDue'));
        $results=HmsModel::getSchedulerResults($vehicleid,$vrn,$unit,$inspectionDue);
        //$this->View->renderJSON($results);
        echo $results;
    }

    public function getAvailableSchedules()
    {
        $vehicleid=$_SESSION['vehicleid'];
        $version=Validate::int(Request::post('version'));
        $results=HmsModel::getAvailableSchedules($vehicleid,$version);
        echo json_encode($results);
    }

    public function encryptColumn()
    {
        $table=Request::get('table');
        $column=Request::get('column');
        $results=HmsModel::encryptColumn($table,$column);
        echo $results;

    }
}